// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import MSSOrchestration

class OrchestrationSampleDelegate {
    weak var viewController: UIViewController?
    var progressDialog: UIView?
}

extension OrchestrationSampleDelegate: OrchestrationErrorDelegate {
    func orchestrator(_ orchestrator: Orchestrator, didReceiveError error: OrchestrationError) {
        guard let viewController = viewController else {
            return
        }
        
        // Hide progress dialog and display failure alert
        if progressDialog != nil {
            UIUtils.hideProgress(progressDialog)
        }

        UIUtils.displayAlert(for: error, on: viewController)
        print("Exception in onOrchestrationError: \(error)")
    }
    
    func orchestrator(_ orchestrator: Orchestrator, didReceiveServerError error: OrchestrationServerError) {
        guard let viewController = viewController else {
            return
        }
        
        // Hide progress dialog and display failure alert
        if progressDialog != nil {
            UIUtils.hideProgress(progressDialog)
        }
        
        UIUtils.displayAlert(controller: viewController, title: "dialog_error_title".localized, message: error.readableMessage)
        print("Exception in onOrchestrationError", error.customPayload ?? "")
    }
}

extension OrchestrationSampleDelegate: OrchestrationWarningDelegate {
    func orchestrator(_ orchestrator: Orchestrator, didReceiveWarning warning: OrchestrationWarning) {
        let warningMessage = [
            warning.errorDescription,
            warning.failureReason,
            "\(warning.warningCode)"
        ].compactMap { $0 }.joined(separator: " - ")
        print("Warning: \(warningMessage)")
    }
}
